/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_decode ( eq, data, enable) ;

  parameter lpm_type = "lpm_decode" ;
  parameter lpm_width = 1 ;
  parameter lpm_decodes = 1 << lpm_width ;
  parameter polar_data   = "NORMAL" ;
  parameter polar_enable = "NORMAL" ;
  parameter polar_eq     = "NORMAL" ;

  input  [lpm_width-1:0] data ;
  input  enable ;
  output [lpm_decodes-1:0] eq ;

  // Internal nets
  reg [lpm_width-1:0] pdata ;
  reg penable ;
  reg [lpm_decodes-1:0] tmp_eq;
  wire enable_in;
 
  nmos     N1 (enable_in, enable, 1'b1) ;
  pullup P1 ( enable_in) ;
  
  initial
  begin
	if (lpm_decodes > (1 << lpm_width) )
	  begin
		$display("%d: Error: Decode must be <= 2^lpm_width.", $time);
		$stop;
	  end
  end

  always @(data)
  begin
    pdata <= #1 (polar_data == "INVERT")?~data:data  ;
  end

  always @(enable_in)
  begin
    penable <= #1 (polar_enable == "INVERT")?~enable_in:enable_in ;
  end

  always @(pdata or penable) 
    begin
	  tmp_eq = 0 ;
      if(penable && (pdata < lpm_decodes))
        begin
            tmp_eq[pdata] = 1'b1 ;
        end
    end

  assign eq = (polar_eq == "INVERT")? ~tmp_eq: tmp_eq ;
endmodule // LPM_DECODE
`ifdef SYNTH
`else
`endcelldefine
`endif
 
